require( "scripts/controls/fonts.lua" );

kDefaultButtonClickSound="audio/sfx/menu/click_button.ogg";
kDefaultButtonOverSound="audio/sfx/menu/activate_button.ogg";

kBuyButtonClickSound="audio/sfx/shop/click_buy_button.ogg";
kBuyButtonOverSound="audio/sfx/menu/activate_button.ogg";

DefaultButtonSound = {
    ClickSound="audio/sfx/menu/click_button.ogg";
    OverSound="audio/sfx/menu/activate_button.ogg";
};

NoButtonSound = {
    ClickSound="";
    OverSound="";
};

NoButtonGraphics = {};

LeftArrowButtonGraphics = {
	"ui/buttons/shop_arrow_l",
	"ui/buttons/shop_arrow_l_p",
	"ui/buttons/shop_arrow_l_a"
};

FloCafeButtonGraphics = {
    "map/cafe_flo",
    "map/cafe_flo_a",
    "map/cafe_flo",
    "map/cafe_flo_a",
};

DarlaCafeButtonGraphics = {
    "map/cafe_darla",
    "map/cafe_darla_a",
    "map/cafe_darla",
    "map/cafe_darla_a",
};

ItalianCafeButtonGraphics = {
    "map/cafe_italian",
    "map/cafe_italian_a",
    "map/cafe_italian",
    "map/cafe_italian_a",
};

JapanCafeButtonGraphics = {
    "map/cafe_japan",
    "map/cafe_japan_a",
    "map/cafe_japan",
    "map/cafe_japan_a",
};

FloTVCafeButtonGraphics = {
    "map/cafe_flo_tv",
    "map/cafe_flo_tv_a",
    "map/cafe_flo_tv",
    "map/cafe_flo_tv_a",
};

MapStartButtonGraphics = {
    "ui/buttons/map_start_buttonup.png",
    "ui/buttons/map_start_buttondown",
    "ui/buttons/map_start_buttonrollover",
};

MapBackButtonGraphics = {
    "ui/buttons/map_back_buttonup.png",
    "ui/buttons/map_back_buttondown",
    "ui/buttons/map_back_buttonrollover",
};

MapGoalButtonGraphics = {
    "map/dot_off",
    "map/dot_on",
    "map/dot_off",
    "map/dot_on"
};

MapExpertButtonGraphics = {
    "map/expert_off",
    "map/expert_on",
    "map/expert_off",
    "map/expert_on"
};

MapLockedButtonGraphics = {
    "map/locked",
    "map/locked",
    "map/locked",
    "map/locked"
};

PauseButtonGraphics = {
    "ui/buttons/pause_buttonup",
    "ui/buttons/pause_buttondown",
    "ui/buttons/pause_buttonrollover"
};

UpgradeButtonGraphics = {
    "ui/buttons/upgrade_button",
    "ui/buttons/upgrade_button_p",
    "ui/buttons/upgrade_button_a"
};

StandardButtonGraphics = {
    "ui/buttons/buttonup",
    "ui/buttons/buttondown",
    "ui/buttons/buttonrollover"
};

LongButtonGraphics = {
    "ui/buttons/long_button_up.png",
    "ui/buttons/long_button_down.png",
    "ui/buttons/long_button_over.png"
};

NameButtonGraphics = {
    "ui/buttons/choosenameover.png",
    "ui/buttons/choosenamedown.png",
    "ui/buttons/choosenameover.png",
    "ui/buttons/choosenamedown.png"
};

CheckboxButtonGraphics = {
    "ui/buttons/checkup",
    "ui/buttons/checkdown",
    "ui/buttons/checkover",
    "ui/buttons/checkdownover"
};

ShopButtonGraphics = {
    "ui/buttons/shop_button",
	"ui/buttons/shop_button_p",
	"ui/buttons/shop_button_a"
};

ShopLeftArrowGraphics = {
    "ui/buttons/shop_arrow_l",
    "ui/buttons/shop_arrow_l_p",
    "ui/buttons/shop_arrow_l_a"
};

ShopRightArrowGraphics = {
    "ui/buttons/shop_arrow_r",
    "ui/buttons/shop_arrow_r_p",
    "ui/buttons/shop_arrow_r_a"
};

function CreatePushButtonStyle(graphicsSet, ButtonSound)
    CurrentButtonStyle = {
        graphics = graphicsSet,
        type = kPush,
        sound = ButtonSound.ClickSound,
        rolloversound = ButtonSound.OverSound,
    };
    return CurrentButtonStyle;
end;

function CreateRadioButtonStyle(graphicsSet, ButtonSound)
    CurrentButtonStyle = {
        graphics = graphicsSet,
        type = kRadio,
        sound = ButtonSound.ClickSound,
        rolloversound = ButtonSound.OverSound,
    };
    return CurrentButtonStyle;
end;

function CreateCheckButtonStyle(graphicsSet, ButtonSound)
    CurrentButtonStyle = {
        graphics = graphicsSet,
        type = kToggle,
        sound = ButtonSound.ClickSound,
        rolloversound = ButtonSound.OverSound,
    };
    return CurrentButtonStyle;
end;

--[[
kUp  Button is in "up" or "off" state.  
kDown  Button is in "down" or "on" state.  
kOver  Button is in roll-over state (and is off for toggles and radio buttons).  
kOverOn  Button is in roll-over state and is "on".  
]]--

-- outline
--CreateText(0, 20, "#"..GetString("make_outline",label), 4, 3),

function CreateMapRadioButtonText(label)
    return Group({
        SelectLayer(0),
        SetStyle(CreateTextStyle(FontGame, 15, WhiteColor)),
        CreateText(0, 26, label, 4, 4),
	SetStyle(CreateTextStyle(FontGame, 15, WhiteColor)),
        CreateText(0, 26, label, 0, 0),
        SetStyle(CreateTextStyle(FontGame, 15, BlackColor)),
        CreateText(0, 26, label, 2, 2),

        SelectLayer(1),
        SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
        CreateText(0, 28, label, 4, 3),
        SetStyle(CreateTextStyle(FontGame, 20, WhiteColor)),
--        CreateText(0, 28, label, 0, 0),
CreateText(0, 28, "#"..GetString("make_outline",label), 0,0),
        
        SelectLayer(2),
        SetStyle(CreateTextStyle(FontGame, 15, WhiteColor)),
        CreateText(0, 26, label, 4, 3),
        SetStyle(CreateTextStyle(FontGame, 15, WhiteColor)),
        CreateText(0, 26, label, 0, 0),
	SetStyle(CreateTextStyle(FontGame, 15, BlackColor)),
        CreateText(0, 26, label, 2, 0),

        SelectLayer(3),
        SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
        CreateText(0, 28, label, 4, 3),
        SetStyle(CreateTextStyle(FontGame, 20, WhiteColor)),
--        CreateText(0, 28, label, 0, 0),
CreateText(0, 28, "#"..GetString("make_outline",label), 0,-1),
    })
end